-- [ja] ルール
--[[
	基本的にキー操作とサウンドはoverlayのほうで設定 
	楽曲情報や必要な変数、画面遷移もすべてoverlayで処理 
	他はあくまで表示内容だけ設定 
--]]
local t = LoadFallbackB();
if GAMESTATE:IsPlayerEnabled(PLAYER_1) then
t[#t+1] = StandardDecorationFromFileOptional( "GrooveRadarP1_Default", "GrooveRadarP1_Default" )..{
	InitCommand=cmd(diffuseshift;effectcolor1,BoostColor(PlayerColor(PLAYER_1),1.5);effectcolor2,BoostColor(PlayerColor(PLAYER_1),1);effectperiod,5);
};
end
if GAMESTATE:IsPlayerEnabled(PLAYER_2) then
t[#t+1] = StandardDecorationFromFileOptional( "GrooveRadarP2_Default", "GrooveRadarP2_Default" )..{
	InitCommand=cmd(diffuseshift;effectcolor1,BoostColor(PlayerColor(PLAYER_2),1);effectcolor2,BoostColor(PlayerColor(PLAYER_2),1.5);effectperiod,5);
};
end

t[#t+1] = StandardDecorationFromFileOptional("TimeLabel","TimeLabel");

t[#t+1] = StandardDecorationFromFileOptional("SongTime","SongTime") .. {
	SetCommand=function(self)
		local curSelection = nil;
		local length = 0.0;
		if GAMESTATE:IsCourseMode() then
			curSelection = GAMESTATE:GetCurrentCourse();
			self:playcommand("Reset");
			if curSelection then
				local trail = GAMESTATE:GetCurrentTrail(GAMESTATE:GetMasterPlayerNumber());
				if trail then
					length = TrailUtil.GetTotalSeconds(trail);
				else
					length = 0.0;
				end;
			else
				length = 0.0;
			end;
		else
			curSelection = GAMESTATE:GetCurrentSong();
			self:playcommand("Reset");
			if curSelection then
				length = curSelection:MusicLengthSeconds();
				if curSelection:IsLong() then
					self:playcommand("Long");
				elseif curSelection:IsMarathon() then
					self:playcommand("Marathon");
				else
					self:playcommand("Reset");
				end
			else
				length = 0.0;
				self:playcommand("Reset");
			end;
		end;
		self:settext( SecondsToMSS(length) );
	end;
	CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
	CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
	CurrentTrailP1ChangedMessageCommand=cmd(playcommand,"Set");
	CurrentTrailP2ChangedMessageCommand=cmd(playcommand,"Set");
}

t[#t+1] = StandardDecorationFromFileOptional("StageDisplay","StageDisplay");
t[#t+1] = StandardDecorationFromFileOptional("StepsDisplayList","StepsDisplayList");

t[#t+1] = StandardDecorationFromFileOptional("BPMDisplay","BPMDisplay");
t[#t+1] = StandardDecorationFromFileOptional("BPMLabel","BPMLabel");

t[#t+1] = Def.ActorFrame{
	LoadActor(THEME:GetPathG("","DifficultyList.png"))..{
		OnCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y+130;zoomx,1.18;zoomy,0.46);
		OffCommand=cmd(sleep,0.266;accelerate,0.133;addx,-SCREEN_WIDTH/2);
	};
};

t[#t+1] = Def.ActorFrame{
	LoadActor(THEME:GetPathG("","_GrooveRadar base (doubleres).png"))..{
		OnCommand=cmd(x,SCREEN_CENTER_X-210;zoom,0.7;y,374);
		OffCommand=cmd(sleep,0.033;accelerate,0.33;addx,-400);
	};
};
t[#t+1] = Def.ActorFrame{
	LoadActor(THEME:GetPathG("","radarlabels (doubleres).png"))..{
		OnCommand=cmd(x,SCREEN_CENTER_X-209.5;y,366;zoom,0.85);
		OffCommand=cmd(linear,0.1;zoom,0);
	};
};

local function PercentScore(pn)
	local t = LoadFont("ScoreDisplay2")..{
		InitCommand=cmd(draworder,600;zoom,0.625;shadowlength,1);
		BeginCommand=cmd(playcommand,"Set");
		SetCommand=function(self)
			local SongOrCourse, StepsOrTrail;
			if GAMESTATE:IsCourseMode() then
				SongOrCourse = GAMESTATE:GetCurrentCourse();
				StepsOrTrail = GAMESTATE:GetCurrentTrail(pn);
			else
				SongOrCourse = GAMESTATE:GetCurrentSong();
				StepsOrTrail = GAMESTATE:GetCurrentSteps(pn);
			end;

			local profile, scorelist;
			local text = "";
			if SongOrCourse and StepsOrTrail then
				local st = StepsOrTrail:GetStepsType();
				local diff = StepsOrTrail:GetDifficulty();
				local courseType = GAMESTATE:IsCourseMode() and SongOrCourse:GetCourseType() or nil;
				local cd = GetCustomDifficulty(st, diff, courseType);
				self:diffuse(CustomDifficultyToColor(cd));
				self:shadowcolor(CustomDifficultyToDarkColor(cd));

				if PROFILEMAN:IsPersistentProfile(pn) then
					-- player profile
					profile = PROFILEMAN:GetProfile(pn);
				else
					-- machine profile
					profile = PROFILEMAN:GetMachineProfile();
				end;

				scorelist = profile:GetHighScoreList(SongOrCourse,StepsOrTrail);
				assert(scorelist)
				local scores = scorelist:GetHighScores();
				local topscore = scores[1];
				if topscore then
					text = string.format("%.2f%%", topscore:GetPercentDP()*100.0);
					-- 100% hack
					if text == "100.00%" then
						text = "100.00%";
					end;
				else
					text = string.format("%.2f%%", 0);
				end;
			else
				text = "";
			end;
			self:settext(text);
		end;
		CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
		CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");
	};

	if pn == PLAYER_1 then
		t.CurrentStepsP1ChangedMessageCommand=cmd(playcommand,"Set");
		t.CurrentTrailP1ChangedMessageCommand=cmd(playcommand,"Set");
	else
		t.CurrentStepsP2ChangedMessageCommand=cmd(playcommand,"Set");
		t.CurrentTrailP2ChangedMessageCommand=cmd(playcommand,"Set");
	end

	return t;
end


for pn in ivalues(PlayerNumber) do
	
	if ShowStandardDecoration("PercentScore"..ToEnumShortString(pn)) then
		t[#t+1] = StandardDecorationFromTable("PercentScore"..ToEnumShortString(pn), PercentScore(pn));
	end;
end
local function GetDifListX(self,pn,offset,fade)
	if pn==PLAYER_1 then
		--self:horizalign(left);
		self:x(SCREEN_CENTER_X-146-offset);
		if fade>0 then
			self:faderight(fade);
		end;
	else
		--self:horizalign(right);
		self:x(SCREEN_CENTER_X-178+offset);
		if fade>0 then
			self:fadeleft(fade);
		end;
	end;
	return r;
end;

local wid = 131

local function DrawDifList(pn,diff)
	local t = Def.ActorFrame {
		InitCommand=cmd(player,pn;y,SCREEN_CENTER_Y+93;addy,900;sleep,0.5;linear,0.05;addy,-900;);
		--full comboﾀｲｳｹ

		LoadActor(THEME:GetPathG("Player","Badge FullCombo"))..{

			InitCommand=cmd(shadowlength,1;zoom,0);
			BeginCommand=cmd(playcommand,"Set");
			OffCommand=cmd(decelerate,0.05;diffusealpha,0;);
			SetCommand=function(self)
				local st=GAMESTATE:GetCurrentStyle():GetStepsType();
				local song=GAMESTATE:GetCurrentSong();
			if song then
				GetDifListX(self,pn,wid,0);
				self:addx(11);
				self:y(GetFlexDifListY(diff, st, song)-3);
				if song:HasStepsTypeAndDifficulty(st,diff) then
					local steps = song:GetOneSteps( st, diff );
					if PROFILEMAN:IsPersistentProfile(pn) then
						-- player profile
						profile = PROFILEMAN:GetProfile(pn);
					else
						-- machine profile
						profile = PROFILEMAN:GetMachineProfile();
					end;
					scorelist = profile:GetHighScoreList(song,steps);
					assert(scorelist);
					local scores = scorelist:GetHighScores();
					assert(scores);
					local topscore;

					if scores[1] then
						topscore = scores[1];
						assert(topscore);
						local misses = topscore:GetTapNoteScore("TapNoteScore_Miss")+topscore:GetTapNoteScore("TapNoteScore_CheckpointMiss")
						local boos = topscore:GetTapNoteScore("TapNoteScore_W5")
						local goods = topscore:GetTapNoteScore("TapNoteScore_W4")
						local greats = topscore:GetTapNoteScore("TapNoteScore_W3")
						local perfects = topscore:GetTapNoteScore("TapNoteScore_W2")
						local marvelous = topscore:GetTapNoteScore("TapNoteScore_W1")
						if (misses+boos+goods) == 0 and scores[1]:GetScore() > 0 and (marvelous+perfects)>0 then
							if (greats+perfects) == 0 then

								self:diffuse(color("#ffffee"));
								self:glowblink();
								self:effectperiod(0.20);
								self:zoom(0.25);
							elseif greats == 0 then
								self:diffuse(color("#fafc3e"));
								self:glowshift();
								self:zoom(0.25);
							else
								self:diffuse(color("#06fd32"));
								self:stopeffect();
								self:zoom(0.25);
							end;
							self:diffusealpha(0.8);
						else 
							self:diffusealpha(0);
						end;
					else
						self:diffusealpha(0);
					end;

					
					
				else
					self:diffusealpha(0);
				end;
			end;
		end;
			CurrentSongChangedMessageCommand=cmd(queuecommand,"Set");
			CurrentTrailP1ChangedMessageCommand=cmd(playcommand,"Set");
			CurrentTrailP2ChangedMessageCommand=cmd(playcommand,"Set");

		};

		Def.Quad{
			InitCommand=cmd(shadowlength,1;zoom,0.20;);
			BeginCommand=cmd(playcommand,"Set");
			OffCommand=cmd(decelerate,0.05;diffusealpha,0;);
			SetCommand=function(self)
				local st=GAMESTATE:GetCurrentStyle():GetStepsType();
				local song=GAMESTATE:GetCurrentSong();
		if song then
				GetDifListX(self,pn,wid,0);
				self:y(GetFlexDifListY(diff, st, song));
				if song:HasStepsTypeAndDifficulty(st,diff) then
					local steps = song:GetOneSteps( st, diff );

					if PROFILEMAN:IsPersistentProfile(pn) then

						-- player profile
						profile = PROFILEMAN:GetProfile(pn);
					else
						-- machine profile
						profile = PROFILEMAN:GetMachineProfile();
					end;

					local scorelist = profile:GetHighScoreList(song,steps);
					assert(scorelist);
					local scores = scorelist:GetHighScores();
					assert(scores);
					local topgrade;

					if scores[1] then
						topgrade = scores[1]:GetGrade();
						assert(topgrade);
						if scores[1]:GetScore()>1  then

							if scores[1]:GetScore()==1000000 and topgrade=="Grade_Tier17" then --AutoPlayHack
								self:LoadBackground(THEME:GetPathG("myMusicWheel","Tier01"));
								self:diffusealpha(1);

							else --Normal
								self:LoadBackground(THEME:GetPathG("myMusicWheel",ToEnumShortString(topgrade)));
								self:diffusealpha(1);
							end;
						else
							self:diffusealpha(0);
						end;

					else
						self:diffusealpha(0);
					end;
				else
					self:diffusealpha(0);
				end;
			end;
		end;
			CurrentSongChangedMessageCommand=cmd(playcommand,"Set");
			CurrentStepsP1ChangedMessageCommand=cmd(playcommand,"Set");
			CurrentStepsP2ChangedMessageCommand=cmd(playcommand,"Set");
			CurrentTrailP1ChangedMessageCommand=cmd(playcommand,"Set");
			CurrentTrailP2ChangedMessageCommand=cmd(playcommand,"Set");
			CurrentCourseChangedMessageCommand=cmd(playcommand,"Set");

		};
	};
	return t;
end;

local act = Def.ActorFrame{
	FOV=60;
	StartMessageCommand=cmd(playcommand,"Off");
	LoadActor(THEME:GetPathG("ScreenWithMenuElements","header"))..{
		InitCommand=function(self)
			self:x(SCREEN_CENTER_X);
			self:y(SCREEN_TOP);
		end;
	};
	Def.Sprite{
		InitCommand=cmd(Center;addy,-50);
		SetSongMessageCommand=function(self,params)
			if params.Song then
				self:LoadBackground(GetEXFSongState_Jacket(GetEXFCurrentSong()));
				self:zoomtowidth(160);
				self:zoomtoheight(160);							
			end;
		end;
	};
	Def.Sprite{
		InitCommand=cmd(Center;addx,160;addy,-70);
		SetSongMessageCommand=function(self,params)
			if params.Song then
				self:LoadBackground(GetEXFSongState_Jacket(GetEXFSongR(1)));
				self:zoomtowidth(120);
				self:zoomtoheight(120);							
			end;
		end;
	};
	Def.Sprite{
		InitCommand=cmd(Center;addx,300;addy,-70);
		SetSongMessageCommand=function(self,params)
			if params.Song then
				self:LoadBackground(GetEXFSongState_Jacket(GetEXFSongR(2)));
				self:zoomtowidth(120);
				self:zoomtoheight(120);							
			end;
		end;
	};
		Def.Sprite{
		InitCommand=cmd(Center;addx,440;addy,-70);
		SetSongMessageCommand=function(self,params)
			if params.Song then
				self:LoadBackground(GetEXFSongState_Jacket(GetEXFSongR(3)));
				self:zoomtowidth(120);
				self:zoomtoheight(120);							
			end;
		end;
	};
	Def.Sprite{
		InitCommand=cmd(Center;addx,-160;addy,-70);
		SetSongMessageCommand=function(self,params)
			if params.Song then
				self:LoadBackground(GetEXFSongState_Jacket(GetEXFSongR(-1)));
				self:zoomtowidth(120);
				self:zoomtoheight(120);							
			end;
		end;
	};
	Def.Sprite{
		InitCommand=cmd(Center;addx,-300;addy,-70);
		SetSongMessageCommand=function(self,params)
			if params.Song then
				self:LoadBackground(GetEXFSongState_Jacket(GetEXFSongR(-2)));
				self:zoomtowidth(120);
				self:zoomtoheight(120);							
			end;
		end;
	};
	Def.Sprite{
		InitCommand=cmd(Center;addx,-440;addy,-70);
		SetSongMessageCommand=function(self,params)
			if params.Song then
				self:LoadBackground(GetEXFSongState_Jacket(GetEXFSongR(-3)));
				self:zoomtowidth(120);
				self:zoomtoheight(120);							
			end;
		end;
	};

	-- [ja] タイトル 
	LoadFont('Common Normal')..{
		InitCommand=cmd(Center;addy,44;strokecolor,0,0,0,1.0;zoom,0.9);
		SetSongMessageCommand=function(self,params)
			if params.Song then
				self:settext(GetEXFSongState_Title(GetEXFCurrentSong()));
			else
				self:settext('');
			end;
		end;
	};
	-- [ja] サブタイトル 
	LoadFont('Common Normal')..{
		InitCommand=cmd(Center;addy,60;strokecolor,0,0,0,1.0;zoom,0.8);
		SetSongMessageCommand=function(self,params)
			if params.Song then
				self:settext(GetEXFSongState_SubTitle(GetEXFCurrentSong()));
			else
				self:settext('');
			end;
		end;
	};
	-- [ja] アーティスト 
	LoadFont('Common Normal')..{
		InitCommand=cmd(Center;addy,65;strokecolor,0,0,0,1.0;zoom,0.7);
		SetSongMessageCommand=function(self,params)
			if params.Song then
				self:settext(GetEXFSongState_Artist(GetEXFCurrentSong()));
			else
				self:settext('');
			end;
		end;
	};
};

t[#t+1] = act;
return t;